/*!
 * \file wsexception.hpp
 * \brief WSoptics exceptions
 *
 *	Copyright 2016 - 2018 WSoptics GmbH
 */

#pragma once

#include <memory>
#include <string>

class WSexception {
public:
	//! Default ctor
	WSexception() = default;

	WSexception(WSexception &&) = delete;
	WSexception(WSexception const &) = delete;
	WSexception & operator=(WSexception &&) = delete;
	WSexception & operator=(WSexception const &) = delete;

	//! Default dtor
	virtual ~WSexception() = default;

	//! Ctor with what message from string
	explicit WSexception(std::string whatArg) : whatStr_(std::move(whatArg)) {}

	//! Return the error associated to the exception
	virtual std::string const & what() const { return whatStr_; }

private:
	//! The what message associated to the exception
	std::string whatStr_;
};

class WSCerealException : public WSexception {
public:
	using WSexception::WSexception;
};
