/*!
 * \file wsassert.hpp
 * \brief WSoptics assertions
 *
 *	Copyright 2016 - 2022 WSoptics GmbH
 */

#pragma once

#ifndef NDEBUG
#include <cassert>
#endif

#ifdef NDEBUG
#define WSassert(expr) static_cast<void>(0)
#else
#define WSassert(expr) assert(expr) // NOLINT(cppcoreguidelines-pro-bounds-array-to-pointer-decay)
#endif

//! Assertion that lhs is equal to rhs, but compute lhs even if in release mode
#ifndef NDEBUG
#define WSasserteval(lhs, rhs) WSassert((lhs) == (rhs))
#else // NDEBUG
#define WSasserteval(lhs, rhs) ((void) lhs)
#endif // NDEBUG
